/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.animation.impl.RollAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Dodge;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.VectorUtil;
import java.nio.ByteBuffer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Roll
extends Action {
    private int creativeCoolTime = 0;
    private boolean startRequired = false;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, IStamina stamina) {
        if (player.m_7578_()) {
            if (KeyBindings.getKeyBreakfall().m_90857_() && KeyBindings.getKeyForward().m_90857_() && !parkourability.get(Dodge.class).isDoing() && ((Boolean)ParCoolConfig.CONFIG_CLIENT.enableRollWhenCreative.get()).booleanValue() && player.m_7500_() && parkourability.getAdditionalProperties().getLandingTick() <= 1 && player.m_20096_() && !this.isDoing() && this.creativeCoolTime == 0) {
                this.startRequired = true;
                this.creativeCoolTime = 20;
            }
            if (this.creativeCoolTime > 0) {
                --this.creativeCoolTime;
            }
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @Override
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        BufferUtil.wrap(startInfo).putBoolean(KeyBindings.getKeyBack().m_90857_());
        return this.startRequired;
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return this.getDoingTick() < this.getRollMaxTick();
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        this.startRequired = false;
        Direction direction = BufferUtil.getBoolean(startData) ? Direction.Back : Direction.Front;
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new RollAnimator(direction));
        }
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        this.startRequired = false;
        Direction direction = BufferUtil.getBoolean(startData) ? Direction.Back : Direction.Front;
        double modifier = Math.sqrt(player.m_20205_());
        Vec3 vec = VectorUtil.fromYawDegree(player.f_20883_).m_82490_(modifier);
        if (direction == Direction.Back) {
            vec = vec.m_82548_();
        }
        player.m_20334_(vec.f_82479_, 0.0, vec.f_82481_);
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new RollAnimator(direction));
        }
    }

    public void startRoll(Player player) {
        this.startRequired = true;
    }

    public int getRollMaxTick() {
        return 9;
    }

    public static enum Direction {
        Front,
        Back;

    }
}

